% clear all; clc;

% rng(0);

N = 256;            % Port number
f_c = 3.5e9;        % Frequency

Lambda = 3e8/f_c;   % Wavelength

L = 9;              % Path number

W = [35:10:45];             % Aperture length per wavelength

Rep = 100;

for w = 1:length(W)
    x = linspace(0,W(w)*Lambda,N)';
    Kernal_CDL_mean = zeros(N,N);
    for rp = 1:Rep
        h = CDL_channel(x, f_c);
        Kernal_CDL_mean = Kernal_CDL_mean + h*h';
    end
    Kernal_CDL_mean = Kernal_CDL_mean/Rep;
    save(['Kernal_W_' num2str(W(w)) '.mat'],'N','x','Kernal_CDL_mean');
end



